
#ifndef GEN_RELEASE_H
#define GEN_RELEASE_H

/*
 * Includes
 */

#include "DX_VOS_basetypes.h" 

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:09:43 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version PLAT_SystemDep.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/
/* --------------------------------------------
	defines shared by a couple of modules
--------------------------------------------------*/



/* .................... basic Macros for accessing hardware registers ...................... */
/* ----------------------------------------------------------------------------------------- */
#define DX_GEN_WriteRegister(addr,val)  ( (*((volatile DxUint32_t*)(addr))) = (DxUint32_t)(val) )
#define DX_GEN_ReadRegister(addr,val)  ( (val) = (*((volatile DxUint32_t*)(addr))) )
#define DX_GEN_WriteRegister16Bit(addr,val)  ( (*((volatile DxUint16_t*)(addr))) = (DxUint16_t)(val) )
#define DX_GEN_ReadRegister16Bit(addr,val)  ( (val) = (*((volatile DxUint16_t*)(addr))) )
#define DX_GEN_WriteRegister8Bit(addr,val)  ( (*((volatile DxUint8_t*)(addr))) = (DxUint8_t)(val) )
#define DX_GEN_ReadRegister8Bit(addr,val)  ( (val) = (*((volatile DxUint8_t*)(addr))) )


/* .................... Macros for hardware registers block utilities ...................... */
/* ----------------------------------------------------------------------------------------- */

#define DX_GEN_WriteRegistersBlock( addr , buffer , size_in_words ) \
do \
{ \
  DxUint32_t i,k; \
  for ( i = 0 , k=(addr) ; i < (size_in_words) ; k+=sizeof(DxUint32_t) , i++ ) \
  { \
    DX_GEN_WriteRegister( k , (buffer)[i] ); \
  } \
}while(0)       

#define DX_GEN_ClearRegistersBlock( addr , size_in_words ) \
do \
{ \
  DxUint32_t i,k; \
  for ( i = 0 , k=(addr) ; i < (size_in_words) ; k+=sizeof(DxUint32_t) , i++ ) \
  { \
    DX_GEN_WriteRegister( k , 0UL ); \
  } \
}while(0)       

#define DX_GEN_ReadRegistersBlock( addr , buffer , size_in_words ) \
do \
{ \
  DxUint32_t i,k; \
  for ( i = 0 , k=(addr) ; i < (size_in_words) ; k+=sizeof(DxUint32_t) , i++ ) \
  { \
    DX_GEN_ReadRegister( k , (buffer)[i] ); \
  } \
}while(0)       


/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif





